﻿/*  Author:     Ben Hall
 *  File:       Encounter.cs
 *  Date:       4/28/2011
 *  
 *  Purpose:    Encounter.cs holds an array of up to five AICharacters that are involved in
 *              a single combat encounter, as well as a float value representing the chance
 *              that the encounter has of being selected out of the Encounter array of the
 *              GameMap it is located in.
 */
using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;

namespace OnlineGame
{
    public class Encounter
    {
        private AICharacter[] opponents;
        private float encounterChance;

        public Encounter(AICharacter[] opponentListIn, float encounterChanceIn)
        {
            this.opponents = opponentListIn;
            this.encounterChance = encounterChanceIn;
        }

        /*  GetOpponentList() returns a copy of the Encounter's AICharacter array to be used
         *  in combat
         */
        public AICharacter[] GetOpponentList()
        {
            AICharacter[] listToReturn = new AICharacter[opponents.Length];
            for (int i = 0; i < listToReturn.Length; i++)
            {
                listToReturn[i] = GetCopyOfAI(opponents[i]);
            }
            return listToReturn;
        }

        /*  GetCopyOfAI() takes an AICharacter and returns an AICharacter that is an identical copy
         *  of that AICharacter.
         */
        public AICharacter GetCopyOfAI(AICharacter AIToCopyIn)
        {
            AICharacter AIToReturn;
            if (AIToCopyIn is AttackerAI)
            {
                AIToReturn = new AttackerAI(AIToCopyIn.GetName(), AIToCopyIn.GetStrength(), AIToCopyIn.GetStamina(), AIToCopyIn.GetAgility(), AIToCopyIn.GetIntelligence(), AIToCopyIn.GetFaith(), AIToCopyIn.GetPersona(), AIToCopyIn.GetCurrencyCarried());
            }
            else if (AIToCopyIn is BalancedAI)
            {
                AIToReturn = new BalancedAI(AIToCopyIn.GetName(), AIToCopyIn.GetStrength(), AIToCopyIn.GetStamina(), AIToCopyIn.GetAgility(), AIToCopyIn.GetIntelligence(), AIToCopyIn.GetFaith(), AIToCopyIn.GetPersona(), AIToCopyIn.GetCurrencyCarried());
            }
            else if (AIToCopyIn is DefenderAI)
            {
                AIToReturn = new DefenderAI(AIToCopyIn.GetName(), AIToCopyIn.GetStrength(), AIToCopyIn.GetStamina(), AIToCopyIn.GetAgility(), AIToCopyIn.GetIntelligence(), AIToCopyIn.GetFaith(), AIToCopyIn.GetPersona(), AIToCopyIn.GetCurrencyCarried());
            }
            else if (AIToCopyIn is HealerAI)
            {
                AIToReturn = new HealerAI(AIToCopyIn.GetName(), AIToCopyIn.GetStrength(), AIToCopyIn.GetStamina(), AIToCopyIn.GetAgility(), AIToCopyIn.GetIntelligence(), AIToCopyIn.GetFaith(), AIToCopyIn.GetPersona(), AIToCopyIn.GetCurrencyCarried());
            }
            else
            {
                AIToReturn = null;
            }
            if (AIToReturn != null)
            {
                AIToReturn.SetPortrait(AIToCopyIn.GetPortrait());
                AIToReturn.SetDamage(AIToCopyIn.GetMinDamage(), AIToCopyIn.GetMaxDamage());
                AIToReturn.SetArmor(AIToCopyIn.GetArmor());
                //add skills
                bool[] AIToCopySkillsKnown = AIToCopyIn.GetSkillsKnown();
                for (int i = 0; i < AIToCopySkillsKnown.Length; i++)
                {
                    if (AIToCopySkillsKnown[i] == true)
                    {
                        AIToReturn.AddSkill(i);
                    }
                }
                AIToReturn.DetermineLevel();
            }

            return AIToReturn;
        }

        public float GetEncounterChance()
        {
            return this.encounterChance;
        }
    }
}
